<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * Company
 *
 * @ORM\Table(name="company")
 * @ORM\Entity
 * @ORM\HasLifecycleCallbacks()
 *
 * @ExclusionPolicy("all")
 */
class Company
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails", "teacherReportsList", "manage"})
     */
    private $id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails", "teacherReportsList", "manage"})
     */
    private $name;

    /**
     * @var string $address
     *
     * @ORM\Column(name="address", type="string", length=255, nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $address;

    /**
     * @var integer $representationNumber
     *
     * @ORM\Column(name="representation_number", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $representationNumber = 0;

    /**
     * @var string $includeChefInRepresentation
     *
     * @ORM\Column(name="include_chef_in_representation", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $includeChefInRepresentation = false;

    /**
     * @var integer
     *
     * @ORM\Column(name="user_groups_id", type="integer")
     *
     */
    private $userGroupsId;

    /**
     * @var integer
     *
     * @ORM\Column(name="production_price", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $productionPrice = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="production_amount", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $productionAmount = 0;

    /**
     * @ORM\ManyToOne(targetEntity="UserGroups",inversedBy="company")
     * @ORM\JoinColumn(name="user_groups_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $userGroups;

    /**
     * @var string $completed
     *
     * @ORM\Column(name="completed", type="boolean")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $completed = false;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;

    /**
     * @var integer
     *
     * @ORM\Column(name="create_user_id", type="integer")
     *
     */
    private $createUserId;

    /**
     * @var integer
     *
     * @ORM\Column(name="creator_state", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $creatorState = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="change_production_cost", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $changeProductionCost = 0;

    /**
     * @var integer
     *
     * @ORM\Column(name="creator_completed", type="boolean")
     *
     */
    private $creatorCompleted = false;

    /**
     * @ORM\ManyToOne(targetEntity="User",inversedBy="creatorCompany")
     * @ORM\JoinColumn(name="create_user_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $createUser;

    /**
     * @ORM\OneToMany(targetEntity="CreatorStagesCompanyConfirm", mappedBy="company")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails", "details"})
     */
    protected $creatorStagesCompanyConfirms;

    /**
     * @ORM\OneToMany(targetEntity="CompanyAllegroCategoryItem", mappedBy="company", cascade={"persist"}, orphanRemoval=true)
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    protected $places;

    /**
     * @ORM\OneToMany(targetEntity="CompanyBankServiceOption", mappedBy="company", cascade={"persist"}, orphanRemoval=true)
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    protected $bankServiceOptions;

    /**
     * @ORM\OneToMany(targetEntity="CompanyEmployee", mappedBy="company", cascade={"persist"}, orphanRemoval=true)
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    protected $companyEmployees;

    /**
     * @ORM\ManyToMany(targetEntity="\Import\ApiBundle\Entity\PKD", inversedBy="company"))
     * @ORM\JoinTable(name="company_pkd_rel",
     *      joinColumns={@ORM\JoinColumn(name="company_id", referencedColumnName="id")},
     *      inverseJoinColumns={@ORM\JoinColumn(name="pkd_id", referencedColumnName="id")}
     *      )
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $codesPkd;

    /**
     * @ORM\OneToMany(targetEntity="SummaryRoundBankServiceOption", mappedBy="company")
     */
    protected $summaryRoundBankServiceOption;

    /**
     * @ORM\OneToMany(targetEntity="SummaryCompanyRound", mappedBy="company")
     */
    protected $summaryCompanyRound;

    /**
     * @ORM\OneToMany(targetEntity="CompanyReport", mappedBy="company")
     *
     * @Expose
     * @AnnotationGroups({"teacherReportsList"})
     */
    protected $roundReports;

    /**
     * @ORM\OneToMany(targetEntity="CompanyOfferReport", mappedBy="company")
     */
    private $companyOfferReports;

    /**
     * @ORM\OneToMany(targetEntity="CompanyOffer", mappedBy="company")
     */
    protected $roundOffers;

    /**
     * @ORM\OneToMany(targetEntity="CompanyDistributionSales", mappedBy="company")
     */
    protected $companyDistributionSales;

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->creatorStagesCompanyConfirms = new \Doctrine\Common\Collections\ArrayCollection();
        $this->places = new \Doctrine\Common\Collections\ArrayCollection();
        $this->bankServiceOptions = new \Doctrine\Common\Collections\ArrayCollection();
        $this->companyEmployees = new \Doctrine\Common\Collections\ArrayCollection();
        $this->codesPkd = new \Doctrine\Common\Collections\ArrayCollection();
        $this->summaryRoundBankServiceOption = new \Doctrine\Common\Collections\ArrayCollection();
        $this->summaryCompanyRound = new \Doctrine\Common\Collections\ArrayCollection();
        $this->roundReports = new \Doctrine\Common\Collections\ArrayCollection();
        $this->accountChanges = new \Doctrine\Common\Collections\ArrayCollection();
        $this->companyOfferReports = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return Company
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set address
     *
     * @param string $address
     * @return Company
     */
    public function setAddress($address)
    {
        $this->address = $address;
    
        return $this;
    }

    /**
     * Get address
     *
     * @return string 
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Set representationNumber
     *
     * @param integer $representationNumber
     * @return Company
     */
    public function setRepresentationNumber($representationNumber)
    {
        $this->representationNumber = $representationNumber;
    
        return $this;
    }

    /**
     * Get representationNumber
     *
     * @return integer 
     */
    public function getRepresentationNumber()
    {
        return $this->representationNumber;
    }

    /**
     * Set includeChefInRepresentation
     *
     * @param boolean $includeChefInRepresentation
     * @return Company
     */
    public function setIncludeChefInRepresentation($includeChefInRepresentation)
    {
        $this->includeChefInRepresentation = $includeChefInRepresentation;
    
        return $this;
    }

    /**
     * Get includeChefInRepresentation
     *
     * @return boolean 
     */
    public function getIncludeChefInRepresentation()
    {
        return $this->includeChefInRepresentation;
    }

    /**
     * Set userGroupsId
     *
     * @param integer $userGroupsId
     * @return Company
     */
    public function setUserGroupsId($userGroupsId)
    {
        $this->userGroupsId = $userGroupsId;
    
        return $this;
    }

    /**
     * Get userGroupsId
     *
     * @return integer 
     */
    public function getUserGroupsId()
    {
        return $this->userGroupsId;
    }

    /**
     * Set productionPrice
     *
     * @param integer $productionPrice
     * @return Company
     */
    public function setProductionPrice($productionPrice)
    {
        $this->productionPrice = $productionPrice;
    
        return $this;
    }

    /**
     * Get productionPrice
     *
     * @return integer 
     */
    public function getProductionPrice()
    {
        return $this->productionPrice;
    }

    /**
     * Set productionAmount
     *
     * @param integer $productionAmount
     * @return Company
     */
    public function setProductionAmount($productionAmount)
    {
        $this->productionAmount = $productionAmount;
    
        return $this;
    }

    /**
     * Get productionAmount
     *
     * @return integer 
     */
    public function getProductionAmount()
    {
        return $this->productionAmount;
    }

    /**
     * Set completed
     *
     * @param boolean $completed
     * @return Company
     */
    public function setCompleted($completed)
    {
        $this->completed = $completed;
    
        return $this;
    }

    /**
     * Get completed
     *
     * @return boolean 
     */
    public function getCompleted()
    {
        return $this->completed;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return Company
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set createUserId
     *
     * @param integer $createUserId
     * @return Company
     */
    public function setCreateUserId($createUserId)
    {
        $this->createUserId = $createUserId;
    
        return $this;
    }

    /**
     * Get createUserId
     *
     * @return integer 
     */
    public function getCreateUserId()
    {
        return $this->createUserId;
    }

    /**
     * Set userGroups
     *
     * @param \VM\ApiBundle\Entity\UserGroups $userGroups
     * @return Company
     */
    public function setUserGroups(\VM\ApiBundle\Entity\UserGroups $userGroups = null)
    {
        $this->userGroups = $userGroups;
    
        return $this;
    }

    /**
     * Get userGroups
     *
     * @return \VM\ApiBundle\Entity\UserGroups 
     */
    public function getUserGroups()
    {
        return $this->userGroups;
    }

    /**
     * Set createUser
     *
     * @param \VM\ApiBundle\Entity\User $createUser
     * @return Company
     */
    public function setCreateUser(\VM\ApiBundle\Entity\User $createUser = null)
    {
        $this->createUser = $createUser;
    
        return $this;
    }

    /**
     * Get createUser
     *
     * @return \VM\ApiBundle\Entity\User 
     */
    public function getCreateUser()
    {
        return $this->createUser;
    }

    /**
     * Add creatorStagesCompanyConfirms
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirms
     * @return Company
     */
    public function addCreatorStagesCompanyConfirm(\VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirms)
    {
        $this->creatorStagesCompanyConfirms[] = $creatorStagesCompanyConfirms;
    
        return $this;
    }

    /**
     * Remove creatorStagesCompanyConfirms
     *
     * @param \VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirms
     */
    public function removeCreatorStagesCompanyConfirm(\VM\ApiBundle\Entity\CreatorStagesCompanyConfirm $creatorStagesCompanyConfirms)
    {
        $this->creatorStagesCompanyConfirms->removeElement($creatorStagesCompanyConfirms);
    }

    /**
     * Get creatorStagesCompanyConfirms
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCreatorStagesCompanyConfirms()
    {
        return $this->creatorStagesCompanyConfirms;
    }

    /**
     * Add places
     *
     * @param \VM\ApiBundle\Entity\CompanyAllegroCategoryItem $places
     * @return Company
     */
    public function addPlace(\VM\ApiBundle\Entity\CompanyAllegroCategoryItem $places)
    {
        $this->places[] = $places;
    
        return $this;
    }

    /**
     * Remove places
     *
     * @param \VM\ApiBundle\Entity\CompanyAllegroCategoryItem $places
     */
    public function removePlace(\VM\ApiBundle\Entity\CompanyAllegroCategoryItem $places)
    {
        $this->places->removeElement($places);
    }

    /**
     * Get places
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPlaces()
    {
        return $this->places;
    }

    /**
     * Add bankServiceOptions
     *
     * @param \VM\ApiBundle\Entity\CompanyBankServiceOption $bankServiceOptions
     * @return Company
     */
    public function addBankServiceOption(\VM\ApiBundle\Entity\CompanyBankServiceOption $bankServiceOptions)
    {
        $this->bankServiceOptions[] = $bankServiceOptions;
    
        return $this;
    }

    /**
     * Remove bankServiceOptions
     *
     * @param \VM\ApiBundle\Entity\CompanyBankServiceOption $bankServiceOptions
     */
    public function removeBankServiceOption(\VM\ApiBundle\Entity\CompanyBankServiceOption $bankServiceOptions)
    {
        $this->bankServiceOptions->removeElement($bankServiceOptions);
    }

    /**
     * Get bankServiceOptions
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getBankServiceOptions()
    {
        return $this->bankServiceOptions;
    }

    /**
     * Add companyEmployees
     *
     * @param \VM\ApiBundle\Entity\CompanyEmployee $companyEmployees
     * @return Company
     */
    public function addCompanyEmployee(\VM\ApiBundle\Entity\CompanyEmployee $companyEmployees)
    {
        $this->companyEmployees[] = $companyEmployees;
    
        return $this;
    }

    /**
     * Remove companyEmployees
     *
     * @param \VM\ApiBundle\Entity\CompanyEmployee $companyEmployees
     */
    public function removeCompanyEmployee(\VM\ApiBundle\Entity\CompanyEmployee $companyEmployees)
    {
        $this->companyEmployees->removeElement($companyEmployees);
    }

    /**
     * Get companyEmployees
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyEmployees()
    {
        return $this->companyEmployees;
    }

    /**
     * Add codesPkd
     *
     * @param \Import\ApiBundle\Entity\PKD $codesPkd
     * @return Company
     */
    public function addCodesPkd(\Import\ApiBundle\Entity\PKD $codesPkd)
    {
        $this->codesPkd[] = $codesPkd;
    
        return $this;
    }

    /**
     * Remove codesPkd
     *
     * @param \Import\ApiBundle\Entity\PKD $codesPkd
     */
    public function removeCodesPkd(\Import\ApiBundle\Entity\PKD $codesPkd)
    {
        $this->codesPkd->removeElement($codesPkd);
    }

    /**
     * Get codesPkd
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCodesPkd()
    {
        return $this->codesPkd;
    }

    /**
     * Add summaryRoundBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption
     * @return Company
     */
    public function addSummaryRoundBankServiceOption(\VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption)
    {
        $this->summaryRoundBankServiceOption[] = $summaryRoundBankServiceOption;
    
        return $this;
    }

    /**
     * Remove summaryRoundBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption
     */
    public function removeSummaryRoundBankServiceOption(\VM\ApiBundle\Entity\SummaryRoundBankServiceOption $summaryRoundBankServiceOption)
    {
        $this->summaryRoundBankServiceOption->removeElement($summaryRoundBankServiceOption);
    }

    /**
     * Get summaryRoundBankServiceOption
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSummaryRoundBankServiceOption()
    {
        return $this->summaryRoundBankServiceOption;
    }

    /**
     * Add summaryCompanyRound
     *
     * @param \VM\ApiBundle\Entity\SummaryCompanyRound $summaryCompanyRound
     * @return Company
     */
    public function addSummaryCompanyRound(\VM\ApiBundle\Entity\SummaryCompanyRound $summaryCompanyRound)
    {
        $this->summaryCompanyRound[] = $summaryCompanyRound;
    
        return $this;
    }

    /**
     * Remove summaryCompanyRound
     *
     * @param \VM\ApiBundle\Entity\SummaryCompanyRound $summaryCompanyRound
     */
    public function removeSummaryCompanyRound(\VM\ApiBundle\Entity\SummaryCompanyRound $summaryCompanyRound)
    {
        $this->summaryCompanyRound->removeElement($summaryCompanyRound);
    }

    /**
     * Get summaryCompanyRound
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSummaryCompanyRound()
    {
        return $this->summaryCompanyRound;
    }

    /**
     * Add roundReports
     *
     * @param \VM\ApiBundle\Entity\CompanyReport $roundReports
     * @return Company
     */
    public function addRoundReport(\VM\ApiBundle\Entity\CompanyReport $roundReports)
    {
        $this->roundReports[] = $roundReports;
    
        return $this;
    }

    /**
     * Remove roundReports
     *
     * @param \VM\ApiBundle\Entity\CompanyReport $roundReports
     */
    public function removeRoundReport(\VM\ApiBundle\Entity\CompanyReport $roundReports)
    {
        $this->roundReports->removeElement($roundReports);
    }

    /**
     * Get roundReports
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getRoundReports()
    {
        return $this->roundReports;
    }

    /**
     * Set creatorState
     *
     * @param integer $creatorState
     * @return Company
     */
    public function setCreatorState($creatorState)
    {
        $this->creatorState = $creatorState;
    
        return $this;
    }

    /**
     * Get creatorState
     *
     * @return integer 
     */
    public function getCreatorState()
    {
        return $this->creatorState;
    }

    /**
     * Set creatorCompleted
     *
     * @param boolean $creatorCompleted
     * @return Company
     */
    public function setCreatorCompleted($creatorCompleted)
    {
        $this->creatorCompleted = $creatorCompleted;
    
        return $this;
    }

    /**
     * Get creatorCompleted
     *
     * @return boolean 
     */
    public function getCreatorCompleted()
    {
        return $this->creatorCompleted;
    }

    /**
     * Set changeProductionCost
     *
     * @param integer $changeProductionCost
     * @return Company
     */
    public function setChangeProductionCost($changeProductionCost)
    {
        $this->changeProductionCost = $changeProductionCost;
    
        return $this;
    }

    /**
     * Get changeProductionCost
     *
     * @return integer 
     */
    public function getChangeProductionCost()
    {
        return $this->changeProductionCost;
    }

    /**
     * Add roundOffers
     *
     * @param \VM\ApiBundle\Entity\CompanyOffer $roundOffers
     * @return Company
     */
    public function addRoundOffer(\VM\ApiBundle\Entity\CompanyOffer $roundOffers)
    {
        $this->roundOffers[] = $roundOffers;
    
        return $this;
    }

    /**
     * Remove roundOffers
     *
     * @param \VM\ApiBundle\Entity\CompanyOffer $roundOffers
     */
    public function removeRoundOffer(\VM\ApiBundle\Entity\CompanyOffer $roundOffers)
    {
        $this->roundOffers->removeElement($roundOffers);
    }

    /**
     * Get roundOffers
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getRoundOffers()
    {
        return $this->roundOffers;
    }

    /**
     * Add companyDistributionSales
     *
     * @param \VM\ApiBundle\Entity\CompanyDistributionSales $companyDistributionSales
     * @return Company
     */
    public function addCompanyDistributionSale(\VM\ApiBundle\Entity\CompanyDistributionSales $companyDistributionSales)
    {
        $this->companyDistributionSales[] = $companyDistributionSales;
    
        return $this;
    }

    /**
     * Remove companyDistributionSales
     *
     * @param \VM\ApiBundle\Entity\CompanyDistributionSales $companyDistributionSales
     */
    public function removeCompanyDistributionSale(\VM\ApiBundle\Entity\CompanyDistributionSales $companyDistributionSales)
    {
        $this->companyDistributionSales->removeElement($companyDistributionSales);
    }

    /**
     * Get companyDistributionSales
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyDistributionSales()
    {
        return $this->companyDistributionSales;
    }

    /**
     * Add companyOfferReports
     *
     * @param \VM\ApiBundle\Entity\CompanyOfferReport $companyOfferReports
     * @return Company
     */
    public function addCompanyOfferReport(\VM\ApiBundle\Entity\CompanyOfferReport $companyOfferReports)
    {
        $this->companyOfferReports[] = $companyOfferReports;
    
        return $this;
    }

    /**
     * Remove companyOfferReports
     *
     * @param \VM\ApiBundle\Entity\CompanyOfferReport $companyOfferReports
     */
    public function removeCompanyOfferReport(\VM\ApiBundle\Entity\CompanyOfferReport $companyOfferReports)
    {
        $this->companyOfferReports->removeElement($companyOfferReports);
    }

    /**
     * Get companyOfferReports
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCompanyOfferReports()
    {
        return $this->companyOfferReports;
    }
}